//===========================================================================
//
// Name:			weapons.c
// Function:		weapon configuration
// Programmer:		Mr Elusive
// Last update:		1999-09-08
// Tab Size:		4 (real tabs)
//===========================================================================

#include "inv.h"

#define VEC_ORIGIN						{0, 0, 0}
//projectile flags
#define PFL_WINDOWDAMAGE			1		//projectile damages through window
#define PFL_RETURN					2		//set when projectile returns to owner
//weapon flags
#define WFL_FIRERELEASED			1		//set when projectile is fired with key-up event
//damage types
#define DAMAGETYPE_IMPACT			1		//damage on impact
#define DAMAGETYPE_RADIAL			2		//radial damage
#define DAMAGETYPE_VISIBLE			4		//damage to all entities visible to the projectile
#define DAMAGETYPE_IGNOREARMOR	8		//projectile goes right through armor

//===========================================================================
// Gauntlet
//===========================================================================

projectileinfo //for Gauntlet
{
	name				"gauntletdamage"
	damage				5
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Gauntlet
{
	name				"Phaser"
	number				WEAPONINDEX_PHASER
	projectile			"gauntletdamage"
	numprojectiles		1
	speed				0
} //end weaponinfo

//===========================================================================
// Machinegun
//===========================================================================

projectileinfo //for Machinegun
{
	name				"machinegunbullet"
	damage				10
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Machinegun
{
	name				"FieldAssaultRifle"
	number				WEAPONINDEX_MACHINEGUN
	projectile			"machinegunbullet"
	numprojectiles		1
	speed				0
} //end weaponinfo

//===========================================================================
// Shotgun
//===========================================================================

projectileinfo //for Shotgun
{
	name				"shotgunbullet"
	damage				200
	damagetype			$evalint(DAMAGETYPE_IMPACT|DAMAGETYPE_RADIAL)
	radius				750
}

weaponinfo //Shotgun
{
	name				"RomulanRadGun"
	number				WEAPONINDEX_SHOTGUN
	projectile			"shotgunbullet"
	numprojectiles		1
	speed				770
	primarydangerous	0
//	altdangerous		1
} //end weaponinfo

//===========================================================================
// Grenade Launcher
//===========================================================================

projectileinfo //for Grenade Launcher
{
	name				"grenade"
	damage				100
	radius				300
	damagetype			$evalint(DAMAGETYPE_IMPACT|DAMAGETYPE_RADIAL)
}

weaponinfo //Grenade Launcher
{
	name				"GrenadeLauncher"
	number				WEAPONINDEX_GRENADE_LAUNCHER
	projectile			"grenade"
	numprojectiles		1
	speed				1415
} //end weaponinfo

//===========================================================================
// Rocket Launcher
//===========================================================================

projectileinfo //for Rocket Launcher
{
	name				"rocket"
	damage				120
	radius				350
	damagetype			$evalint(DAMAGETYPE_IMPACT|DAMAGETYPE_RADIAL)
}

weaponinfo //Rocket Launcher
{
	name				"PhotonBurst"
	number				WEAPONINDEX_ROCKET_LAUNCHER
	projectile			"rocket"
	numprojectiles		1
	speed				1100
	altdangerous		1
} //end weaponinfo

//===========================================================================
// Lightning
//===========================================================================

projectileinfo //for Lightning
{
	name				"lightning"
	damage				18
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Railgun
{
	name				"AttrexianRifle"
	number				WEAPONINDEX_LIGHTNING
	projectile			"lightning"
	numprojectiles		1
	speed				0
	altdangerous		1
} //end weaponinfo

projectileinfo //for Lightning
{
	name				"Burst"
	damage				15
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Railgun
{
	name				"BurstRifle"
	number				WEAPONINDEX_BURSTRIFLE
	projectile			"Burst"
	numprojectiles		1
	speed				0
	altdangerous		1
} //end weaponinfo

projectileinfo //for Lightning
{
	name				"CompBullet"
	damage				35
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Railgun
{
	name				"CompressionRifle"
	number				WEAPONINDEX_COMPRIFLE
	projectile			"CompBullet"
	numprojectiles		1
	speed				0
	altdangerous		1
} //end weaponinfo

//===========================================================================
// Railgun
//===========================================================================

projectileinfo //for Railgun
{
	name				"rail"
	damage				45
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Railgun
{
	name				"I-Mod"
	number				WEAPONINDEX_RAILGUN
	projectile			"rail"
	numprojectiles		1
	speed				0
} //end weaponinfo

//===========================================================================
// Plasma Gun
//===========================================================================

projectileinfo //for Plasma Gun
{
	name				"plasma"
	damage				15
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Plasma Gun
{
	name				"TetryonGatlingGun"
	number				WEAPONINDEX_PLASMAGUN
	projectile			"plasma"
	numprojectiles		1
	speed				0
//	altdangerous		1
} //end weaponinfo

//===========================================================================
// BFG10K
//===========================================================================

projectileinfo //for BFG10K
{
	name				"bfgexplosion"
	damage				125
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //compression sniper rifle
{
	name				"FederationSniperRifle"
	number				WEAPONINDEX_BFG
	projectile			"bfgexplosion"
	numprojectiles		1
	speed				0
	altdangerous		1
} //end weaponinfo

//===========================================================================
// Nailgun
//===========================================================================

projectileinfo //for Nailgun
{
	name				"nail"
	damage				50
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Nailgun
{
	name				"DrullStaff"
	number				WEAPONINDEX_NAILGUN
	projectile			"nail"
	numprojectiles		1
	speed				1200
} //end weaponinfo

//===========================================================================
// Prox Launcher
//===========================================================================

projectileinfo //for Prox launcher
{
	name				"mine"
	damage				50
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Nailgun
{
	name				"Batleth"
	number				WEAPONINDEX_PROXLAUNCHER
	projectile			"mine"
	numprojectiles		1
	speed				0
} //end weaponinfo

//===========================================================================
// Chaingun
//===========================================================================

projectileinfo //for Chaingun
{
	name				"chaingunbullet"
	damage				40
	damagetype			DAMAGETYPE_IMPACT
}

weaponinfo //Nailgun
{
	name				"RomulanDisruptor"
	number				WEAPONINDEX_CHAINGUN
	projectile			"chaingunbullet"
	numprojectiles		1
	speed				0
} //end weaponinfo


