<?xml version="1.0" encoding="windows-1252"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <DIV STYLE="padding:.1in .3in .3in .3in; background-color:#000000; background-image=URL(log.gif)">
            <html>
                <head>
                    <title>Execution Log</title>
                </head>
                <body>
                    <h1>
                        <DIV STYLE="padding:.1in .1in .1in .1in; font-family:Lucida Console; font-size:14pt; font-weight:bold; background-color:#7A7A7A; color:black"><xsl:value-of select="LogFile/ProgramName" /></DIV>
                    </h1>
<h1>
<DIV STYLE="color:#7A7A7A; font-family:Lucida Console; font-size:8pt; font-weight:normal">Here is the list of events recorded on <xsl:value-of select="LogFile/TodayDate" /> during the execution of this computer program:</DIV></h1>
                    <table border="0" cellspacing="1" cellpadding="0">
                        <tr>
                            <td bgcolor="#ffffff">
     <table border="0" cellpadding="3" cellspacing="1">
      <tr>
       <td bgcolor="#CA22C8"><SPAN STYLE="color:black; font-family:Tahoma; font-size:12pt; font-weight:normal; font-style:italic"><b>#</b></SPAN></td>
       <td bgcolor="green"><SPAN STYLE="color:black; font-family:Tahoma; font-size:12pt; font-weight:normal; font-style:italic"><b>Time</b></SPAN></td>
       <td bgcolor="#595DF3"><SPAN STYLE="color:black; font-family:Tahoma; font-size:12pt; font-weight:normal; font-style:italic"><b>Event</b></SPAN></td>
       <td bgcolor="#7A00C0"><SPAN STYLE="color:black; font-family:Tahoma; font-size:12pt; font-weight:normal; font-style:italic"><b>Origin</b></SPAN></td>
      </tr>

      <xsl:for-each select="LogFile/LogItem">
       <tr onMouseover="">
        <td bgcolor="#000000" valign="top"><SPAN STYLE="color:#CA22C8; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:number count="LogItem" /></SPAN></td>
        <td bgcolor="#000000" valign="top"><nobr><SPAN STYLE="color:green; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="Time" /></SPAN></nobr></td>
        <td bgcolor="#000000" valign="top"><SPAN STYLE="color:#595DF3; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="Event" /></SPAN>
										   <SPAN STYLE="color:#BFC121; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="WarningEvent" /></SPAN>
										   <SPAN STYLE="color:#CF1313; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="CriticalEvent" /></SPAN>
										   <SPAN STYLE="background-color:#000040; color:#595DF3; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="HighlightedEvent" /></SPAN>
										   <SPAN STYLE="background-color:#3F4000; color:#BFC121; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="HighlightedWarningEvent" /></SPAN>
										   <SPAN STYLE="background-color:#400000; color:#CF1313; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="HighlightedCriticalEvent" /></SPAN></td>
        <td bgcolor="#000000" valign="top"><nobr><SPAN STYLE="background-color:#000000; color:#7A00C0; font-family:Tahoma; font-size:10pt; font-weight:normal; font-style:normal"><xsl:value-of select="SourceFile" /><br /><xsl:value-of select="SourceLine" /></SPAN></nobr></td>
       </tr>
      </xsl:for-each>
     </table>
    </td>
                        </tr>
                    </table>
                    <br/>
                    <SPAN STYLE="color:#7A7A7A; font-family:Lucida Console; font-size:8pt; font-weight:normal">Copyright &#169; 2003 <a href="mailto:bluehair@wanadoo.fr"><SPAN STYLE="color:#D79F07">Yannick "Bluehair" Lon</SPAN></a>. All rights reserved</SPAN>
                </body>
            </html>
        </DIV>
    </xsl:template>
</xsl:stylesheet>
