//-----------------------------------------------------------------------------
//
//  $Logfile:: /Code/DLLs/game/ammo.h                                        $
// $Revision:: 6                                                              $
//   $Author:: Steven                                                         $
//     $Date:: 2/14/03 5:37p                                                  $
//
// Copyright (C) 1997 by Ritual Entertainment, Inc.
// All rights reserved.
//
// This source is may not be distributed and/or modified without
// expressly written permission by Ritual Entertainment, Inc.
//
// DESCRIPTION:
// Base class for all ammunition for entities derived from the Weapon class.
//

#ifndef __AMMO_H__
#define __AMMO_H__

#include "g_local.h"
#include "item.h"

class AmmoEntity : public Item
	{
	private:
		float					_lastPrintTime;

	public:
      CLASS_PROTOTYPE( AmmoEntity );

								AmmoEntity();
      /* virtual */ Item *		ItemPickup( Entity *other, qboolean add_to_inventory, qboolean );
	  /* virtual */ void		cacheStrings( void );
	  /* virtual */ void		Archive( Archiver &arc );
	};

inline void AmmoEntity::Archive( Archiver &arc )
{
	Item::Archive( arc );

	arc.ArchiveFloat( &_lastPrintTime );
}

class Ammo : public Class
	{
   int amount;
   int maxamount;
   str name;
   int name_index;

	public:
      CLASS_PROTOTYPE( Ammo );

	                  Ammo();
                     Ammo(const str &name, int amount, int name_index );

      void           setAmount( int a );
      int            getAmount( void );
      void           setMaxAmount( int a );
      int            getMaxAmount( void );
      void           setName( const str &name );
      str            getName( void );
      int            getIndex( void );
      virtual void   Archive( Archiver &arc );
	};

inline void Ammo::Archive
	(
	Archiver &arc
	)

   {
   Class::Archive( arc );

   arc.ArchiveInteger( &amount );
   arc.ArchiveInteger( &maxamount );
   arc.ArchiveString( &name );

	//
	// name_index not archived, because it is auto-generated by gi.itemindex
	//
   if ( arc.Loading() )
      {
      setName( name );
      }
   }

#endif /* ammo.h */
