struct SKB_Loader
(
	bstream,
	astream,
		
	header,
	animHeader,
	boneNames,
	surfaces,
	baseBoneFrame,
	
	modelFilename,
	modelName,
	modelPath,
	
	animFilename,
	animName,
	animPath,
	
	frames,
	maxBones,
	
	lastFrame = 0,
	
	
	fn Open filename =
	(
		modelFilename 	= filename
		modelName 		= getFileNameFile filename
		modelPath 		= getFileNamePath filename
		
		bstream = fopen filename "rb"
		
		ok
	),
	
	fn Close =
	(
		fclose bstream
		ok
	),
	
	fn ComputeBaseBones = 
	(
		local bones = baseBoneFrame
		
		for b = 1 to header.numBones do
		(
			if boneNames[ b ].parent > 0 then
			(
				-- find the rotation of the current bone by multiplying the current bone rotation by its parent
				bones[ b ].myQuat = QuatMult bones[ b ].myQuat bones[ boneNames[ b ].parent ].myQuat
				
				local offset = MatrixTransformVector bones[ b ].offset bones[ boneNames[ b ].parent ].matrix
				
				bones[ b ].offset = offset + bones[ boneNames[ b ].parent ].offset
				
				bones[ b ].matrix = QuatToMat bones[ b ].myQuat
			)
			else
			(
				bones[ b ].matrix = QuatToMat bones[ b ].myQuat 	
			)
		)
	),
	
	fn ComputeBones = 
	(
		for f = 1 to animHeader.numFrames do
		(
			local bones = frames[ f  ].bones
		
			for b = 1 to header.numBones do
			(
				if boneNames[ b ].parent > 0 then
				(
					-- find the rotation of the current bone by multiplying the current bone rotation by its parent
					bones[ b ].myQuat = QuatMult bones[ b ].myQuat bones[ boneNames[ b ].parent ].myQuat
				
					local offset = MatrixTransformVector bones[ b ].offset bones[ boneNames[ b ].parent ].matrix
					
					bones[ b ].offset = offset + bones[ boneNames[ b ].parent ].offset
				
					bones[ b ].matrix = QuatToMat bones[ b ].myQuat
				)
				else
				(
					bones[ b ].matrix = QuatToMat bones[ b ].myQuat 	
				)
			)
		)
	),
	
	fn LoadSurface surfNum =
	(
		local surface = SKB_Surface()
		surface.LoadFromStream bstream
		--surface.DebugOut()
		
		if not surface.IsValid() then
		(
			return false
		)
		
		surface.LoadData bstream
		
		local surfMesh = surface.CreateMesh surfNum
		
		update surfMesh
		
		append surfaces surface
		
		fseek bstream (surface.ofsStart + surface.ofsEnd) #seek_set
	),
	
	fn ApplyFrames =
	(
		for f = 1 to animHeader.numFrames do
		(
			local progStr = "Loading frame " + (f as string)
			progressStart progStr
			progressUpdate (100.0 * f / animHeader.numFrames)
			local frame = frames[ f ]
			
			animate on at time (f + lastFrame)
			(
				for b = 1 to animHeader.numBones do
				(
					local boneParent = boneNames[ b ].parent
					
					if boneParent != -1 then
					(
						local boneOrigin = frame.bones[ b ].offset
						local boneSpace = frame.bones[ b ].matrix
						
						boneSpace.translation = boneOrigin
						
						maxBones[ b ].transform = boneSpace
					)
					else
					(
						local boneOrigin = frame.bones[ b ].offset
						local boneSpace = frame.bones[ b ].matrix
						
						boneSpace.translation = boneOrigin
						maxBones[ b ].transform = boneSpace
					)
				)
			)
		)
		
		lastFrame += animHeader.numFrames
		progressEnd()
	),
	
	fn LoadAnimation name =
	(
		animFilename	= name
		animName		= getFileNameFile name
		animPath		= getFileNamePath name
		
		astream = fopen name "rb"
		
		animHeader = SKA_Header()
		animHeader.LoadFromStream astream
--		animHeader.DebugOut()
		
		if not animHeader.IsValid() then
		(
			return false
		)
		
		fseek astream animHeader.ofsFrames #seek_set
		frames = #()
		
		for f = 1 to animHeader.numFrames do
		(
			local curFrame = SKA_Frame()
			curFrame.LoadFromStream astream
			
			for b = 1 to animHeader.numBones do
			(	
				local curBone = SKA_Bone()
				curBone.LoadFromStream astream
				append curFrame.bones curBone
			)
			append frames curFrame
		)
		
		ComputeBones()
	),
	
	fn LoadBaseFrame =
	(
		local boneStart
		local boneEnd
		local maxBone
		local zAxis = [0,0,1]
		
		maxBones = #()
		
		for b = 1 to header.numBones do
		(
			local boneParent = boneNames[ b ].parent
			
			if boneParent != -1 then
			(
				boneStart = frames[ 1 ].bones[ boneParent ].offset
				boneEnd = frames[ 1 ].bones[ b ].offset
					
				local boneSpace = frames[ 1 ].bones[ b ].matrix
				boneSpace.translation = boneEnd
					
				maxBone = BoneSys.createBone boneStart boneEnd zAxis
				
				maxBone.width = 0.8
				maxBone.height = 0.8
				in coordsys world maxBone.transform = boneSpace
				maxBone.parent = maxBones[ boneParent ]
				maxBone.name = boneNames[ b ].name
			)
			else
			(
				--end of bone chain
				local boneOrigin = frames[ 1 ].bones[ b ].offset
				local boneSpace = frames[ 1 ].bones[ b ].matrix
				
				boneSpace.translation = boneOrigin
				
				maxBone = dummy name:boneNames[ b ].name boxsize:[1.0, 1.0, 1.0]
				in coordsys world maxBone.transform = boneSpace
			)
			append maxBones maxBone
		)
		
		for b = 1 to maxBones.count do
		(
			maxBones[ b ].resetBoneStretch()
		)
	),
	
	fn CreateSurfaces =
	(
		local bones = frames[ 1 ].bones	
		
		for s = 1 to header.numSurfaces do
		(
			local curSurf = surfaces[ s ]
			local verts = #()
			for v = 1 to curSurf.numVerts do
			(
				local blend = (curSurf.verts[ v ]).weights
				local x = 0.0
				local y = 0.0
				local z = 0.0
				
				for w = 1 to (curSurf.verts[ v ]).numWeights do
				(
					local bone = bones[ blend[ w ].boneIndex + 1 ]
					local temp = MatrixTransformVector blend[ w ].offset bone.matrix

					x += (bone.offset.x + temp.x) * blend[ w ].boneWeight
					y += (bone.offset.y + temp.y) * blend[ w ].boneWeight
					z += (bone.offset.z + temp.z) * blend[ w ].boneWeight
				)
	
				local curVert = point3 x y z
				append verts curVert
			)
			setMesh curSurf.surfMesh vertices:verts
			
			update curSurf.surfMesh
		)
		true
	),
	
	fn SkinSurfaces =
	(		
		for s = 1 to header.numSurfaces do
		(
			local curSurf = surfaces[ s ]
			max modify mode
			modPanel.SetCurrentObject curSurf.surfMesh
				
			local skinMod = skin()
			addModifier curSurf.surfMesh skinMod
			modPanel.SetCurrentObject skinMod
				
			curSurf.skinModBoneMap = #()
			local numSkinModBones = 0
			for boneIndex = 1 to header.numBones do
			(
				local updateFlag = 0
				if boneIndex == header.numBones then 
					updateFlag = -1	
				
				skinOps.AddBone skinMod maxBones[ boneIndex ] updateFlag
				numSkinModBones += 1
					
				append curSurf.skinModBoneMap numSkinModBones
			)
			
			subObjectLevel = 1
			format "Number of skin verts = %\n" (skinOps.GetNumberVertices selection[ 1 ].modifiers[ 1 ])
			format "Number of skin bones = %\n" (skinOps.GetNumberBones selection[ 1 ].modifiers[ 1 ])
										
			disableSceneRedraw()
			for i = 1 to (skinOps.GetNumberVertices skinMod) do
			(
				format "i=% curSurf.numVerts=%\n" i curSurf.numVerts
				local boneWeights = (curSurf.verts[ i ]).weights
					
				local vertBoneIndices = #()
				local vertBoneWeights = #()
					
				for w = 1 to (curSurf.verts[ i ]).numWeights do
				(
					local boneIndex = boneWeights[ w ].boneIndex + 1
					append vertBoneIndices curSurf.skinModBoneMap[boneIndex]
					append vertBoneWeights boneWeights[ w ].boneWeight	
				)
				skinOps.SetVertexWeights skinMod i vertBoneIndices vertBoneWeights
			)
			enableSceneRedraw()
				
			subObjectLevel = 0
		)
		
		--max utility mode
	),
	
	fn ValidateFiles =
	(
		if header.numBones != animHeader.numBones then
		(
			format "Missmatched files, aborting..."
			return false
		)
		true
	),
	
	fn LoadModel =
	(
		fseek bstream 0 #seek_set
		
		header = SKB_Header()
		header.LoadFromStream bstream
		if not header.IsValid() then
		(
			format "Errors found, aborting..."
			ok
		)
--		header.DebugOut()
		
		fseek bstream header.ofsBones #seek_set
		boneNames = #()
		for b = 1 to header.numBones do
		(
			local curBone = SKB_BoneName()
			curBone.LoadFromStream bstream
			append boneNames curBone
--			curBone.DebugOut()
		)

		fseek bstream header.ofsSurfaces #seek_set
		surfaces = #()
		for s = 1 to header.numSurfaces do
		(
			LoadSurface s
		)
		
		--Load in baseFrame
		if header.version == 4 then
		(
			baseBoneFrame = #()
			for b = 1 to header.numBones do
			(
				local curBaseFrame = SKB_BaseFrame()
				curBaseFrame.LoadFromStream bstream
--				format "%\n" boneNames[ b ].name
--				curBaseFrame.DebugOut()
				append baseBoneFrame curBaseFrame
			)
		)
		
		--ComputeBaseBones()
		
		local animName = getOpenFileName caption:"EF2 SKA Importer" types:"EF2 Skeleton Animation File (*.ska)|*.ska|"
		--format "%\n" animName
		
		if (animName != undefined )then
		(
			if (doesFileExist animName) then
			(
				LoadAnimation animName
			)
		)
		
		LoadBaseFrame()
		CreateSurfaces()
		SkinSurfaces()
		
		ApplyFrames()
		
		true	
	)
)
	
	
	