--------------------------------------------------------------------
-- Return to Castle Wolfenstein MDS Importer Version 1.0
-- MAXScript utility for gmax and 3DS Max 4.2
-- 
-- Copyright (C) 2001-2002 Chris Cookson (cjcookson@hotmail.com)
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-- 
-- File Info:
--
-- Common file, error reporting functions etc. 
--------------------------------------------------------------------

global appName = "Wolfenstein MDS Importer"

fn SetAppName name=
(
	appName = name
	ok
)

-- Replacement for doesFileExist which seems to give false positives
fn DoesFileReallyExist filename=
(
	(getFiles filename).count != 0
)

-- Error message box
fn ShowError msg=
(
	format "*** Error: %\n" msg
	messageBox msg title:appName;
	ok
)

-- Error message box and exception
fn FatalError msg=
(
	ShowError msg;
	throw (appName + ":" + msg)
)

-- Quick check, error if fail
fn Check condition msg =
(
	if not condition do
	(
		if msg == unsupplied do msg = "Check failed"
		format "*** Check failed: %\n" msg
		FatalError msg
	)
)

-- Binstream tools

-- Skip over a number of bytes
fn SkipBytes bstream count=
(
	local unknown
	case count of
	(
		2: unknown = ReadShort bstream #unsigned
		4: unknown = ReadLong bstream #unsigned
		default:
		(
			for i = 1 to count do
			(
				unknown = ReadByte bstream #unsigned
			)
		)
	)
)
 	-- Read a string of fixedLen chars
fn ReadFixedString bstream fixedLen=
(
	local str = ""
	for i = 1 to fixedLen do
	(
		local ch = ReadByte bstream #unsigned
		str += bit.intAsChar ch
		if ch == 0 then
		(
			-- Ignore junk
			SkipBytes bstream (fixedLen - i)
			exit
		)
	)
	str
)

-- String utils

-- Get the string a long represents
fn LongToString num=
(
	local str = ""
	for i = 1 to 4 do
	(
		str += bit.intAsChar (bit.and num 0xff)
		-- num = bit.shift num -8
		num /= 256
	)
	str
)

-- Convert to lowercase
fn ToLowerCase instr=
(
	local outstr = copy instr
	local upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	local lower = "abcdefghijklmnopqrstuvwxyz"
	
	for i =1 to outstr.count do
	(
		local pos = findString upper outstr[i]
		if pos != undefined do outstr[i] = lower[pos]
	)
	outstr
)


-- Convert a forward-slash style PK3 path to a windows one
fn ToWindowsPath pakPath=
(
	local winPath = "\\"
	for i = 1 to pakPath.count do
	(
		if pakPath[i] == "/" then
		(
			winPath += "\\"
		) else
		(
			winPath += pakPath[i]
		)
	)
	winPath
)

-- Swap a file's extension	
fn ChangeExt filename newExt=
(
	(getFilenamePath filename) + (getFilenameFile filename) + newExt
)

-- Get the game data path set by the user, or a default one
fn GetDataPath=
(
	if g_gameDataPath != undefined then
	(
		g_gameDataPath
	)
	else
	(
		g_defaultGameDataPath
	)
)

-- Extract the filename of a data file from a PK3 filename
fn GetDataPathFilename filename=
(
	local splitPath = filterString filename "\\/"
	
	if splitPath.count > 0 then
	(
		splitPath[splitPath.count]
	)
	else
	(
		""
	)
)

fn WriteFloat6 x fstream=
	(
		if false then
		(
			format "% " x to:fstream
		)
		else
		(
			local ipart = x as integer
			local fpart = abs (x - ipart)
			ipart = abs ipart
			if x < 0.0 do format "-" to:fstream
			
			local scaledStr = ((1000000.0 * fpart) as integer) as string
			local startPos = amax 1 (7 - scaledStr.count)
			local len = amax 0 (7 - startPos)
			local fracStr = replace "000000" startPos len scaledStr
			format "%.% " ipart fracStr to:fstream
		)
	)

-- Useful little text file tokenizer
struct Tokenizer
(
	tokens = #(),
	
	fn SetString str=
	(
		tokens = filterString str "\t ,"
	),
	
	fn ReadToken=
	(
		if tokens.count > 0 then
		(
			local tok = tokens[1]
			deleteItem tokens 1
			tok
		) else
		(
			undefined
		)
	),
	
	fn PeekToken=
	(
		if tokens.count > 0 then tokens[1] else undefined
	)
)



 
