utility SKB_Importer "EF2 SKB Importer"
(
	group "About:"
	(
		label titleLabel "EF2 SKB Import v1.0 BETA"
		HyperLink addy "by Neil Davis" align:#center address:"mailto:senkusha@spintastics.com" color:(color 0 0 170) hoverColor:(color 170 0 0)
	)
	
	group "Import:"
	(
		button importBase "Import SKB..."
		button importAnimation "Import SKA..."
	)
	
	include "common.ms"
	include "math.ms"
	include "SKEL-Data.ms"
	include "SKEL-Loader.ms"
		
	local theLoader = SKB_loader()
	
	on importBase pressed do
	(
		local fileName = getOpenFileName caption:"EF2 SKB Importer" types:"EF2 Skeleton File (*.skb)|*.skb|"
		--format "%\n" fileName
		
		if (fileName != undefined )then
		(
			if (doesFileExist fileName) then
			(
				theLoader.Open fileName
				theLoader.LoadModel()
				theLoader.Close()
			)
		)
	)
	
	on importAnimation pressed do
	(
		local animName = getOpenFileName caption:"EF2 SKA Importer" types:"EF2 Skeleton Animation File (*.ska)|*.ska|"
		format "%\n" animName
		
		if (animName != undefined )then
		(
			if (doesFileExist animName) then
			(
				theLoader.LoadAnimation animName
				theLoader.ApplyFrames()
			)
		)
	)
)